IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO_CONTABIL]'))
DROP VIEW [dbo].[V_PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO_CONTABIL]
GO
--SELECT * FROM V_PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO_CONTABIL WHERE CD_EMP=1 AND CD_FILIAL=2 AND DT_MOV BETWEEN '20150901' AND '20150903'
CREATE VIEW [dbo].[V_PDV_VD_FECHA_RC_ADM_CARTAO_DEBITO_CONTABIL]
AS
SELECT     
	PDV_VD.CD_EMP, 
	PDV_VD.CD_FILIAL, 
	RC_CLI.CD_CLI, 
	RC_CLI.RZ_CLI AS NM_CARTAO, 
	RC_CLI.CD_CTB_CNT_RED, 
	RC_CLI.CD_CTB_CNT, 
    PDV_VD.DT_VD AS DT_MOV,
	ISNULL(SUM(PDV_VD_TEF.VL_CARTAO),0) AS VLR_CARTAO,
	ISNULL(SUM(PDV_VD_TEF.VL_SAQUE_CARTAO),0) AS VLR_SAQUE_CARTAO,
    0 AS TP_TRANSACAO,
    'VENDAS' AS DS_TRANSACAO	
FROM         
    PDV_VD_TEF INNER JOIN PDV_VD ON 
	PDV_VD_TEF.CD_VD = PDV_VD.CD_VD AND 
	PDV_VD_TEF.CD_FILIAL = PDV_VD.CD_FILIAL AND 
    PDV_VD_TEF.CD_EMP = PDV_VD.CD_EMP 
	INNER JOIN RC_ADM_CARTAO_RC_CLI ON 
    PDV_VD_TEF.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
    PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO
	INNER JOIN RC_CLI ON
	RC_CLI.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
    RC_CLI.CD_CLI = RC_ADM_CARTAO_RC_CLI.CD_CLI 
	INNER JOIN RC_ADM_CARTAO ON 
	PDV_VD_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND 
    PDV_VD_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO  
WHERE 
	RC_ADM_CARTAO.TP_ADM NOT IN (0,2,4)
	AND PDV_VD.ST_VD = 0 
GROUP BY 
	RC_CLI.RZ_CLI, 
	RC_CLI.CD_CTB_CNT_RED, 
	RC_CLI.CD_CTB_CNT, 
	RC_CLI.CD_CLI, 
	PDV_VD.CD_EMP, 
	PDV_VD.CD_FILIAL, 
	PDV_VD.DT_VD
UNION ALL
SELECT     
	PDV_RECBTO_TEF.CD_EMP, 
	PDV_RECBTO_TEF.CD_FILIAL, 
	RC_ADM_CARTAO_RC_CLI.CD_CLI, 
	RC_CLI.RZ_CLI, 
	RC_CLI.CD_CTB_CNT_RED, 
    RC_CLI.CD_CTB_CNT, 
    PDV_CUPOM_NAO_FISCAL.DT_CUPOM, 
    ISNULL(PDV_RECBTO_TEF.VL_CARTAO,0) AS VLR_CARTAO, 
    ISNULL(PDV_RECBTO_TEF.VL_SAQUE_CARTAO,0) AS VLR_SAQUE_CARTAO,
    1 AS TP_TRANSACAO,
    'RECBTO DIVERSOS' AS DS_TRANSACAO
FROM         
	PDV_RECBTO_TEF INNER JOIN PDV_CUPOM_NAO_FISCAL_TEF ON 
	PDV_RECBTO_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP AND 
    PDV_RECBTO_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL AND 
	PDV_RECBTO_TEF.CD_RECTO_TEF = PDV_CUPOM_NAO_FISCAL_TEF.CD_RECTO_TEF 
	INNER JOIN PDV_CUPOM_NAO_FISCAL ON 
	PDV_CUPOM_NAO_FISCAL_TEF.CD_EMP = PDV_CUPOM_NAO_FISCAL.CD_EMP AND 
    PDV_CUPOM_NAO_FISCAL_TEF.CD_FILIAL = PDV_CUPOM_NAO_FISCAL.CD_FILIAL AND 
    PDV_CUPOM_NAO_FISCAL_TEF.CD_CTR = PDV_CUPOM_NAO_FISCAL.CD_CTR 
    INNER JOIN RC_ADM_CARTAO ON 
    PDV_RECBTO_TEF.CD_EMP = RC_ADM_CARTAO.CD_EMP AND 
    PDV_RECBTO_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO.CD_ADM_CARTAO 
    INNER JOIN RC_ADM_CARTAO_RC_CLI ON 
    PDV_RECBTO_TEF.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
    PDV_RECBTO_TEF.CD_ADM_CARTAO = RC_ADM_CARTAO_RC_CLI.CD_ADM_CARTAO 
    INNER JOIN RC_CLI ON 
    RC_ADM_CARTAO_RC_CLI.CD_EMP = RC_CLI.CD_EMP AND 
    RC_ADM_CARTAO_RC_CLI.CD_CLI = RC_CLI.CD_CLI
WHERE 
	RC_ADM_CARTAO.TP_ADM NOT IN (0,2,4)
	AND  PDV_CUPOM_NAO_FISCAL.ST_CUPOM = 0
	AND TP_CUPOM_NAO_FISCAL = 3 AND ST_CUPOM not in(1,2,3)
GO


